import processing.core.*; import java.applet.*; import java.awt.*; import java.awt.image.*; import java.awt.event.*; import java.io.*; import java.net.*; import java.text.*; import java.util.*; import java.util.zip.*; import javax.sound.midi.*; import javax.sound.midi.spi.*; import javax.sound.sampled.*; import javax.sound.sampled.spi.*; import java.util.regex.*; import javax.xml.parsers.*; import javax.xml.transform.*; import javax.xml.transform.dom.*; import javax.xml.transform.sax.*; import javax.xml.transform.stream.*; import org.xml.sax.*; import org.xml.sax.ext.*; import org.xml.sax.helpers.*; public class Button_und_Ampel extends PApplet {/**
 * Ampel mit Schaltfl\u00e4chen 
 * 
 * Schalten: Schaltet weiter zur n\u00e4chsten Ampelphase
 * Reset:    Schaltet die Ampel in den Anfangszustand (rot). 
 * 
 * 2008 - 05 - 15
 */

int Hintergrundfarbe = 0xff999999;
BUTTON b_Schalten;
BUTTON b_Reset;
int rot   = 0xffFF0000;
int gelb  = 0xffFFFF00;
int gruen = 0xff00FF00;
AMPEL A;

public void setup()
{
  size(400, 400);
  smooth(); 
  background(Hintergrundfarbe);
  b_Schalten = new BUTTON(66,  360, 100, 30, "Schalten");
  b_Reset    = new BUTTON(233, 360, 100, 30, "Reset"   );
  A = new AMPEL(200);
}

public void draw() { }

public void mouseReleased()
{
  if ((mouseButton == LEFT) && b_Schalten.angeklickt() )
     { A.Schalten();  b_Schalten.losgelassen();        }
  if ((mouseButton == LEFT) && b_Reset.angeklickt()    )
     { A.Reset();     b_Reset.losgelassen();           }
}

public void mousePressed()
{
  if ((mouseButton == LEFT) && b_Schalten.angeklickt() ) 
     { b_Schalten.gedrueckt(); }
  if ((mouseButton == LEFT) && b_Reset.angeklickt()    )
     { b_Reset.gedrueckt();  }
}

class BUTTON
{
  int x, y, b, h;
  String s;
  PFont font;
  int Buttonfarbe  = 0xffCCCCCC;
  int Schriftfarbe = 0xff000000;
  int Randfarbe_d  = 0xff000000;
  int Randfarbe_h  = 0xffFFFFFF;
  
  BUTTON(int x_neu, int y_neu, int b_neu, int h_neu, String s_neu)
  { 
    x = x_neu; y = y_neu; b = b_neu; h = h_neu; s = s_neu;
    losgelassen();
  }
  
  public void losgelassen()
  {
    stroke(Randfarbe_d); strokeWeight(3); fill(Buttonfarbe);
    rect(x, y, b, h);
    stroke(Randfarbe_h); strokeCap(ROUND);
    line(x, y, x+b, y); line(x, y, x, y+h);
    font = createFont("CALIBRI", 20); 
    textFont(font); 
    fill(Schriftfarbe);
    textAlign(CENTER, CENTER);
    text(s, x, y+3, b, h);
  }
  
  public void gedrueckt()
  {
    stroke(Randfarbe_d); strokeWeight(3); fill(Buttonfarbe);
    rect(x, y, b, h);
    stroke(Randfarbe_h); strokeCap(ROUND);
    line(x, y+h, x+b, y+h); line(x+b, y, x+b, y+h);
    font = createFont("CALIBRI", 20); 
    textFont(font); 
    fill(Schriftfarbe);
    textAlign(CENTER, CENTER);
    text(s, x, y+3, b, h);
  }
  
  public boolean angeklickt()
  {
     return ((mouseX > x) && (mouseX < x+b) && 
             (mouseY > y) && (mouseY < y+h));
  } 
}

public class AMPEL
{
    // Instanzvariablen
    private KREIS    rotesLicht;
    private KREIS    gelbesLicht;
    private KREIS    gruenesLicht;
    private SCHALTER roterSchalter;
    private SCHALTER gelberSchalter;
    private SCHALTER gruenerSchalter;
    private ZAEHLER_ZYKLISCH Zustand;

    /**
     * Konstruktor f\u00fcr Objekte der Klasse AMPEL
     */
    public AMPEL(int xPos)
    {
        // Instanzvariable initialisieren
        rotesLicht      = new KREIS(xPos, 60, 60, rot);
        roterSchalter   = new SCHALTER(rotesLicht);
        gelbesLicht     = new KREIS(xPos, 140, 60, gelb);
        gelberSchalter  = new SCHALTER(gelbesLicht);
        gruenesLicht    = new KREIS(xPos, 220, 60, gruen);
        gruenerSchalter = new SCHALTER(gruenesLicht);
        Zustand         = new ZAEHLER_ZYKLISCH(3);
        Reset();
    }
    
    public void Reset()
    {
       Zustand.Set_Null();
       rot();
    }
    
    public void rot()
    {
        roterSchalter.Einschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Ausschalten();
    }
    
    public void rot_gelb()
    {
        roterSchalter.Einschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Ausschalten();
    }

    public void gruen()
    {
        roterSchalter.Ausschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Einschalten();
    }
    
    public void gelb()
    {
        roterSchalter.Ausschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Ausschalten();
    }
    
    public void alleEinschalten()
    {
        roterSchalter.Einschalten();
        gelberSchalter.Einschalten();
        gruenerSchalter.Einschalten();
    }
    
    public void alleAusschalten()
    {
        roterSchalter.Ausschalten();
        gelberSchalter.Ausschalten();
        gruenerSchalter.Ausschalten();
    }
    
    public void Schalten()
    {
       Zustand.Zaehlen();
       Anzeigen();
    }
    
    private void Anzeigen()
    {
        if (Zustand.Get_Zaehlerstand() == 0) {rot();};
        if (Zustand.Get_Zaehlerstand() == 1) {rot_gelb();};
        if (Zustand.Get_Zaehlerstand() == 2) {gruen();};
        if (Zustand.Get_Zaehlerstand() == 3) {gelb();};
    } 
}

class KREIS
{
  int x, y, r;
  int f;
  int Randfarbe = 0xffFFFFFF;
  
  KREIS(int x_neu, int y_neu, int r_neu, int f_neu)
  {
    x = x_neu; y = y_neu; r = r_neu; f = f_neu;
  }
  
  public void sichtbarMachen()
  {
    stroke(Randfarbe); strokeWeight(2);
    fill(f);
    ellipse(x, y, r, r);
  }
  
  public void unsichtbarMachen()
  {
    stroke(Randfarbe); strokeWeight(2);
    fill(Hintergrundfarbe);
    ellipse(x, y, r, r);
  }
}

public class ZAEHLER_ZYKLISCH
{
    int Zaehlerstand;
    int Max;

    public ZAEHLER_ZYKLISCH(int max)
    {
        Zaehlerstand = 0;
        Max = max;
    }

    public void Set_Null()
    {
        Zaehlerstand = 0;
    }
    
    public void Zaehlen()
    {
        if (Zaehlerstand == Max) {Set_Null();} 
                            else {Zaehlerstand = Zaehlerstand +1;};
        
    }
    
    public int Get_Zaehlerstand()
    {
        return Zaehlerstand;
    }        
}

public class SCHALTER      
{    
    private boolean Schalter_ein;   // Instanzvarable f\u00fcr den Zustand
    private KREIS   Licht;          // Variable zur Visualsierung
    
    /**
     * Konstruktor f\u00fcr Objekte der Klasse Schalter
     * Ausgangszustand: Der Schalter ist aus
     * @param Objekt der Klasse Kreis, dient zur Visualisierung
     */
    public SCHALTER(KREIS k)
    {
        Schalter_ein = false;       // Startzustand setzen
        Licht = k;                  // Speichern des Objektes zur Visualisierung
        Licht.sichtbarMachen();     // sonst erscheint das leere Fenster nicht
        Licht.unsichtbarMachen();   // gew\u00fcnschter Anfangszustand
    }
   
    /**
     * Einschalten
     * Der Schalter steht unabh\u00e4ngig vom Zustand danach auf ein
    */
    public void Einschalten()
    {
        Schalter_ein = true;
        Protokoll("Einschalten");
    }
    
    /**
     * Ausschalten
     * Der Schalter steht unabh\u00e4ngig vom Zustand danach auf aus
    */
    public void Ausschalten()
    {
        Schalter_ein = false;
        Protokoll("Ausschalten");
    } 
    
    
    public boolean Get_Schalterstellung()
    {
        return Schalter_ein;
    }
    
    /**
     * Umschalten
     * Der Schalter hat ABH\u00c4NGIG vom Zustand danach den jeweils anderen Zustand
    */
    public void Umschalten()
    {
        Protokoll("Umschalten");
        if (Get_Schalterstellung()) {Ausschalten();} else {Einschalten();};
    }
    
    private void Protokoll(String gerufen_von)
    {
        if (Get_Schalterstellung()) {Licht.sichtbarMachen();}
                               else {Licht.unsichtbarMachen();};
     }
                            
    
}

  static public void main(String args[]) {     PApplet.main(new String[] { "Button_und_Ampel" });  }}